<?php
// Enqueue the parent theme's stylesheet

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');


// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    // wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);
    wp_enqueue_script(
        'bootstrap-bundle-js',
        'https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/js/bootstrap.bundle.min.js',
        array('jquery'),
        null,
        true
    );
}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');

//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    //  Slick carousel script
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    //  Slick carousel CSS
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');

// custom code


// Professionals slider start 
function display_professional_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'our-professionals'
    );

    $args = array(
        'post_type' => 'our-professionals',
        'posts_per_page' => $atts['posts_per_page'],
    );

    $professionals_query = new WP_Query($args);

    ob_start();

    if ($professionals_query->have_posts()): ?>
        <div class="professional_slider">
            <?php while ($professionals_query->have_posts()):
                $professionals_query->the_post();
                ?>

                <div class="p-3">
                    <div class="video-box">
                        <div class="img-box mb-3" data-bs-toggle="modal" data-bs-target="#videoModal">
                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail('full', array('class' => 'd-block w-100'));
                            } ?>
                        </div>
                        <h3 class="mt-0 mb-1"><?php echo get_the_title(); ?></h3>
                        <p class="lh-base">
                            <?php echo get_the_excerpt(); ?>
                        </p>
                    </div>
                </div>

            <?php endwhile; ?>
        </div>
        <script type="text/javascript">
            jQuery(document).ready(function ($) {
                if ($(".professional_slider").length && typeof $.fn.slick === "function") {
                    $(".professional_slider").slick({
                        dots: false,
                        arrows: true,
                        autoplay: true,
                        autoplaySpeed: 3000,
                        slidesToShow: 3,
                        slidesToScroll: 1,
                        responsive: [
                            {
                                breakpoint: 992,
                                settings: {
                                    slidesToShow: 2
                                }
                            },
                            {
                                breakpoint: 576,
                                settings: {
                                    slidesToShow: 1
                                }
                            }
                        ]
                    });
                }
            });
        </script>


    <?php else:
        echo 'No professionals found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('professional_slider', 'display_professional_slider');
// professionals slider end ------------------------------



// professionals page start ------------------------------------------------------------

function display_professionals($atts)
{
    // Shortcode attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
            'category' => isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '',
            'speciality' => isset($_GET['speciality']) ? sanitize_text_field($_GET['speciality']) : '',
            'search' => isset($_GET['keyword']) ? sanitize_text_field($_GET['keyword']) : '',
        ),
        $atts,
        'professionals_list'
    );

    $paged = get_query_var('paged') ? get_query_var('paged') : 1;

    // WP_Query arguments
    $args = array(
        'post_type' => 'our-professionals',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => $paged,
    );

    if (!empty($atts['search'])) {
        $args['s'] = $atts['search'];
    }

    if (!empty($atts['category'])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'professionals',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }

    if (!empty($atts['speciality'])) {
        $args['meta_query'][] = array(
            'key' => 'speciality',
            'value' => $atts['speciality'],
            'compare' => 'LIKE',
        );
    }

    // Get all taxonomy terms
    $categories = get_terms(array(
        'taxonomy' => 'professionals',
        'hide_empty' => true,
    ));

    // Get unique specialities from posts
    $specialities = array();
    $posts = get_posts(array(
        'post_type' => 'our-professionals',
        'numberposts' => -1,
        'post_status' => 'publish',
        'fields' => 'ids',
    ));

    foreach ($posts as $post_id) {
        $spec = get_post_meta($post_id, 'speciality', true);
        if (!empty($spec) && !in_array($spec, $specialities)) {
            $specialities[] = $spec;
        }
    }
    sort($specialities);

    ob_start();
    ?>

    <div class="row justify-content-center pb-5">
        <!-- Professionals Dropdown -->
        <div class="col-md-3 mb-2">
            <div class="dropdown professional-filter">
                <button type="button" class="btn btn-primary dropdown-toggle" data-bs-toggle="dropdown">
                <?php
    if (!empty($atts['category'])) {
        $current_cat = get_term_by('slug', $atts['category'], 'professionals');
        echo esc_html($current_cat ? $current_cat->name : 'Professionals');
    } else {
        echo 'Professionals';
    }
    ?>
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="<?php echo esc_url(remove_query_arg('category')); ?>">All</a></li>
                    <?php foreach ($categories as $cat): ?>
                        <li>
                            <a class="dropdown-item <?php echo ($atts['category'] === $cat->slug) ? 'active' : ''; ?>"
                                href="<?php echo esc_url(add_query_arg('category', $cat->slug)); ?>">
                                <?php echo esc_html($cat->name); ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>

        <!-- Specialities Dropdown -->
        <div class="col-md-3 mb-2">
            <div class="dropdown professional-filter">
                <button type="button" class="btn btn-primary dropdown-toggle" data-bs-toggle="dropdown">
                <?php
    if (!empty($atts['speciality'])) {
        echo esc_html($atts['speciality']);
    } else {
        echo 'Specialities';
    }
    ?>
                </button>
                <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="<?php echo esc_url(remove_query_arg('speciality')); ?>">All</a></li>
                    <?php foreach ($specialities as $spec): ?>
                        <li>
                            <a class="dropdown-item <?php echo ($atts['speciality'] === $spec) ? 'active' : ''; ?>"
                                href="<?php echo esc_url(add_query_arg('speciality', urlencode($spec))); ?>">
                                <?php echo esc_html($spec); ?>
                            </a>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </div>
        </div>
    </div>

    <?php
    $professionals_query = new WP_Query($args);

    if ($professionals_query->have_posts()): ?>
        <div id="professionals-results" class="professionals_list-page professionals-main">
            <div class="row g-md-4 g-3">
                <?php while ($professionals_query->have_posts()):
                    $professionals_query->the_post(); ?>
                    <div class="col-lg-4 col-sm-6">
                        <div class="video-box">
                            <div class="img-box mb-3" data-bs-toggle="modal"
                                data-bs-target="#testimonialModal<?php echo get_the_ID(); ?>">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>
                                <img src="https://draftsite1.com/bridge-healthcare/wp-content/uploads/2025/05/icon-plus-circle.png"
                                    alt="" class="play-button" width="60">
                            </div>
                            <h3 class="mt-0 mb-1"><?php the_title(); ?></h3>
                            <p class="lh-base"><?php echo get_the_excerpt(); ?></p>
                        </div>
                    </div>
                <?php endwhile; ?>
            </div>

            <?php while ($professionals_query->have_posts()):
                $professionals_query->the_post(); ?>
                <div class="modal fade" id="testimonialModal<?php echo get_the_ID(); ?>">
                    <div class="modal-dialog modal-dialog-centered modal-lg">
                        <div class="modal-content rounded-0 border-0">
                            <div class="modal-body p-5">
                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                <div class="row">
                                    <div class="col-md-5">
                                        <div class="video-box">
                                            <div class="img-box mb-3">
                                                <?php if (has_post_thumbnail()) {
                                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                                } ?>
                                            </div>
                                            <h3 class="mt-0 mb-1"><?php the_title(); ?></h3>
                                            <?php
                                            $designation = get_field('designation');
                                            if ($designation):
                                                echo '<p class="fw-normal">' . esc_html($designation) . '</p>';
                                            endif;
                                            ?>
                                        </div>
                                    </div>
                                    <div class="col-md-7">
                                        <div class="professsion-details ps-lg-4">
                                            <?php
                                            $speciality = get_field('speciality');
                                            if ($speciality):
                                                echo '<h6>Speciality:</h6>';
                                                echo '<div class="badge mt-2">' . esc_html($speciality) . '</div>';
                                            endif;
                                            ?>
                                            <div class="mt-4"><?php echo get_the_content(); ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>

        <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
            <div class="pagination-two">
                <?php
                echo paginate_links(array(
                    'total' => $professionals_query->max_num_pages,
                    'current' => max(1, $paged),
                    'format' => '?paged=%#%',
                    'add_args' => array_filter(array(
                        'category' => $atts['category'],
                        'speciality' => $atts['speciality'],
                        's' => $atts['search'],
                    )),
                    'show_all' => false,
                    'type' => 'plain',
                    'prev_text' => __('<img src="https://draftsite1.com/bridge-healthcare/wp-content/uploads/2025/05/arrow-left.png">'),
                    'next_text' => __('<img src="https://draftsite1.com/bridge-healthcare/wp-content/uploads/2025/05/arrow-right.png">'),
                    'end_size' => 2,
                    'mid_size' => 2,
                ));
                ?>
            </div>
        </div>
    <?php else:
        echo '<p>No professionals found.</p>';
    endif;

    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('professionals_list', 'display_professionals');

// professionals page End ------------------------------------------------------------





// memberships slider start 
function display_membership_slider($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => -1,
            'category' => '', // taxonomy slug
        ),
        $atts,
        'membership_slider'
    );

    $args = array(
        'post_type' => 'membership',
        'posts_per_page' => $atts['posts_per_page'],
    );

    if (!empty($atts['category'])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'membership-type',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }

    $memberships_query = new WP_Query($args);

    ob_start();

    if ($memberships_query->have_posts()): ?>

        <div class="row justify-content-between g-0">
            <div class="col-lg-3">
                <h2 class="membership-title">Membership <br> Benefits</h2>
                <div class="slider-controls">
                    <button class="prev-btn">Prev</button>
                    <button class="next-btn ms-3">Next</button>
                </div>
            </div>
            <div class="col-lg-8">
                <div class="membership_slider">
                    <?php while ($memberships_query->have_posts()):
                        $memberships_query->the_post(); ?>
                        <div class="p-3 items">
                            <div class="membership-box">
                                <div class="img-box mb-3" data-bs-toggle="modal" data-bs-target="#videoModal">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                    } ?>
                                </div>
                                <h3 class="mt-0 mb-1 text-white"><?php the_title(); ?></h3>
                                <div class="lh-base text-white"><?php the_excerpt(); ?></div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>

                <script type="text/javascript">
                    jQuery(document).ready(function ($) {
                        if ($(".membership_slider").length && typeof $.fn.slick === "function") {
                            $(".membership_slider").slick({
                                centerMode: false,
                                centerPadding: '150px',
                                dots: false,
                                arrows: true,
                                rows: 2,
                                // slidesPerRow: 3,
                                slidesToShow: 2,
                                slidesToScroll: 1,
                                infinite: false,
                                responsive: [
                                    {
                                        breakpoint: 992,
                                        settings: {
                                            // slidesToShow: 2,
                                            // rows: 1,
                                            // slidesPerRow: 1
                                            slidesToShow: 2,
                                            slidesToScroll: 1
                                        }
                                    },
                                    {
                                        breakpoint: 576,
                                        settings: {
                                            slidesToShow: 1,
                                            slidesToScroll: 1
                                            // slidesToShow: 1,
                                            // rows: 1,
                                            // slidesPerRow: 1
                                        }
                                    }
                                ]
                            });
                            $(".prev-btn").on("click", function () {
                                $(".membership_slider").slick("slickPrev");
                            });
                            $(".next-btn").on("click", function () {
                                $(".membership_slider").slick("slickNext");
                            });
                        }
                    });
                </script>
            </div>
        </div>

    <?php else:
        echo '<div class="text-center">No memberships found.</div>';
    endif;

    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('membership_slider', 'display_membership_slider');

// memberships slider end ------------------------------









add_action('wp_footer', 'custom_elementor_tab_redirect_script');
function custom_elementor_tab_redirect_script()
{
    ?>
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const media1 = document.getElementById("sone1");
            if (media1) {
                media1.addEventListener("click", function () {
                    window.location.href = "https://draftsite1.com/bridge-healthcare/comprehensive-health-management-program";
                });
            }

            const media2 = document.getElementById("sone2");
            if (media2) {
                media2.addEventListener("click", function () {
                    window.location.href = "https://draftsite1.com/bridge-healthcare/functional-test-for-wellness";
                });
            }

            const media3 = document.getElementById("sone3");
            if (media3) {
                media3.addEventListener("click", function () {
                    window.location.href = "https://draftsite1.com/bridge-healthcare/international-healthcare-services";
                });
            }
        });
    </script>
    <script>
        jQuery(document).ready(function ($) {
            // Hover to activate e-n-tab
            $('.home-tab .e-n-tab-title').on('mouseenter', function () {
                $(this).trigger('click');
            });
        });
    </script>

    <script>
        jQuery(document).ready(function ($) {
            let hoverTimer;

            $('.home-tab .e-n-tab-title').on('mouseenter', function () {
                const $this = $(this);
                hoverTimer = setTimeout(function () {
                    $this.trigger('click');
                }, 150); // 150ms delay
            });

            $('.home-tab .e-n-tab-title').on('mouseleave', function () {
                clearTimeout(hoverTimer);
            });
        });
    </script>

    <?php
}










function wpb_woocommerce_product_categories_accordion()
{
    // Get the current queried product category
    $queried_object = get_queried_object();
    $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

    // Get all parent categories of the current category
    $current_category_parents = [];
    if ($current_category_id) {
        $parent_categories = get_ancestors($current_category_id, 'product_cat');
        $current_category_parents = array_map('intval', $parent_categories);
    }

    // Recursive function to get subcategories with checkboxes
    function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
    {
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => $parent_id,
            'hide_empty' => false
        );
        $sub_categories = get_terms($args);

        if (!empty($sub_categories)) {
            echo '<ul class="list-unstyled ps-2">';
            foreach ($sub_categories as $sub_category) {
                $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                echo '<li class="' . $active_class . '">';
                echo '<div class="in-menu">';
                echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';

                echo '<a href="' . get_term_link($sub_category) . '">  <span class="customcheck"></span>' . $sub_category->name . '</a>';
                echo '</div>';
                get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                echo '</li>';
            }
            echo '</ul>';
        }
    }

    // Get main product categories (parent categories)
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => 'name',
        'order' => 'ASC',
        'parent' => 0,
        'hide_empty' => false
    );
    $product_categories = get_terms($args);

    if ($product_categories) {
        ob_start();
        ?>
        <div class="accordion" id="productCategoriesAccordion">

            <?php
            $shop_page_url = wc_get_page_permalink('shop');
            $is_shop_page = is_shop();
            ?>

            <!-- <div class="accordion-item">
                    <div class="accordion-header <?php //echo $is_shop_page ? 'current-category' : ''; 
                            ?>">
                        <label>
                            <a href="<?php // echo esc_url($shop_page_url); 
                                    ?>" class="main-category">
                                All Product
                            </a>
                        </label>
                    </div>
                </div> -->


            <?php
            $i = 0;
            foreach ($product_categories as $category) {
                $i++;

                // Check if the category has subcategories
                $sub_args = array(
                    'taxonomy' => 'product_cat',
                    'parent' => $category->term_id,
                    'hide_empty' => true
                );
                $sub_categories = get_terms($sub_args);
                $has_subcategories = !empty($sub_categories);

                // Determine if this category should be expanded
                $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
                ?>
                <div class="accordion-item <?php echo $active_class; ?>">
                    <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                        <label for="cat<?php echo $category->term_id; ?>">
                            <input type="checkbox" class="category-checkbox me-2" id="cat<?php echo $category->term_id; ?>"
                                data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>

                            <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                <span class="customcheck"></span>
                                <?php echo $category->name . ' <span class="count">(' . $category->count . ')</span>'; ?>
                            </a>
                        </label>

                        <?php if ($has_subcategories) { ?>
                            <button class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                aria-controls="collapse<?php echo $i; ?>" data-category-id="<?php echo $category->term_id; ?>">
                                <i class="fa fa-angle-down"></i>
                            </button>
                        <?php } ?>
                    </div>
                    <?php if ($has_subcategories) { ?>
                        <div id="collapse<?php echo $i; ?>" class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                            aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                            <div class="accordion-body ps-0 pe-0">
                                <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
                <?php
            }
            ?>
        </div>

        <script>
            document.addEventListener("DOMContentLoaded", function () {
                var savedCategories = JSON.parse(localStorage.getItem("checkedCategories")) || [];

                savedCategories.forEach(function (categoryId) {
                    var checkbox = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                    if (checkbox) {
                        checkbox.checked = true;
                    }
                });

                document.querySelectorAll(".category-checkbox").forEach(function (checkbox) {
                    checkbox.addEventListener("change", function () {
                        var categoryId = this.getAttribute("data-category-id");
                        if (this.checked) {
                            if (!savedCategories.includes(categoryId)) {
                                savedCategories.push(categoryId);
                            }
                        } else {
                            savedCategories = savedCategories.filter(id => id !== categoryId);
                        }
                        localStorage.setItem("checkedCategories", JSON.stringify(savedCategories));
                    });
                });

                var activeCategory = localStorage.getItem("activeCategory");
                if (activeCategory) {
                    var activeAccordion = document.querySelector('[data-category-id="' + activeCategory + '"]');
                    if (activeAccordion) {
                        var collapseElement = activeAccordion.getAttribute("data-bs-target");
                        document.querySelector(collapseElement).classList.add("show");
                        activeAccordion.classList.remove("collapsed");
                        activeAccordion.setAttribute("aria-expanded", "true");
                    }
                }

                document.querySelectorAll(".accordion-button").forEach(function (button) {
                    button.addEventListener("click", function () {
                        var categoryId = this.getAttribute("data-category-id");
                        if (document.querySelector(this.getAttribute("data-bs-target")).classList.contains("show")) {
                            localStorage.removeItem("activeCategory");
                        } else {
                            localStorage.setItem("activeCategory", categoryId);
                        }
                    });
                });
            });
        </script>

        <style>
            .current-category>a {
                font-weight: bold;
                color: #ff6600;
            }

            .category-checkbox {
                display: none;
            }

            span.customcheck {
                background: #FFFFFF 0% 0% no-repeat padding-box;
                border: 1px solid #BEC0C5;
                border-radius: 0px;
                width: 15px;
                height: 15px;
                position: relative;
                margin-right: 2px;
                margin-top: 0px;
                top: 2px;
                display: none;
            }

            .current-category [type=checkbox]:checked~a span.customcheck {
                background: #BEC0C5;
                border-color: #BEC0C5;
            }

            .current-category [type=checkbox]~a .customcheck:after {
                content: "";
                position: absolute;
            }

            .current-category a input:checked~.customcheck:after {
                display: block;
            }

            .current-category a .customcheck:after {
                left: 5px;
                top: 2px;
                width: 4px;
                height: 8px;
                border: solid white;
                border-width: 0 2px 2px 0;
                -webkit-transform: rotate(45deg);
                -ms-transform: rotate(45deg);
                transform: rotate(45deg);
            }
        </style>
        <?php
        return ob_get_clean();
    }
}

add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');




// Wrap WooCommerce product image in a div start ----------
add_action('woocommerce_before_shop_loop_item_title', 'wrap_product_image_in_div', 5);
function wrap_product_image_in_div()
{
    echo '<div class="custom-image-wrapper">';
}
add_action('woocommerce_before_shop_loop_item_title', 'close_product_image_div', 15);
function close_product_image_div()
{
    echo '</div>';
}



// Wrap WooCommerce product image in a div end ----------


add_action('wp_footer', 'hide_gallery_thumbs_if_single_image');
function hide_gallery_thumbs_if_single_image()
{
    if (is_product()): ?>
        <script>
            jQuery(document).ready(function ($) {
                $(window).on('load', function () {
                    var thumbCount = $('.wpgis-slider-nav .slick-slide').length;

                    if (thumbCount <= 1) {
                        $('.wpgis-slider-nav').hide();
                    } else {
                        $('.wpgis-slider-nav').show();
                    }
                });
            });
        </script>

    <?php endif;
}





// enquiry product code start --------------
// Agar price nahi ho to "Price on Request" dikhaye
add_filter('woocommerce_get_price_html', 'custom_price_on_request_text', 10, 2);
function custom_price_on_request_text($price, $product)
{
    if ($product->get_price() === '') {
        return '<span class="price-on-request">Price on Request</span>';
    }
    return $price;
}

// Single product page ke liye

// Single product page ke liye
add_action('woocommerce_single_product_summary', 'replace_add_to_cart_with_enquire_now', 30);
function replace_add_to_cart_with_enquire_now()
{
    global $product;

    if ($product->get_price() === '') {
        // Remove add to cart button
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);

        // Show Enquire Now button
        echo '<a href="' . site_url('/contact-us') . '" class="button enquire-now">Enquire Now</a>';
    }
}

// Shop/Archive pages ke liye
add_filter('woocommerce_loop_add_to_cart_link', 'custom_enquire_now_button_loop', 10, 2);
function custom_enquire_now_button_loop($button, $product)
{
    if ($product->get_price() === '') {
        $button = '<a href="' . site_url('/contact-us') . '" class="button enquire-now">Enquire Now</a>';
    }
    return $button;
}


// Shop/Archive pages ke liye



// enquiry product code end --------------



// validation woocommerce start --------------------

add_action('woocommerce_save_account_details_errors', 'validate_my_account_fields', 10, 1);

function validate_my_account_fields($errors)
{
    // Validate First Name
    if (isset($_POST['account_first_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_first_name'])) {
        $errors->add('validation', __('Allowed characters for First Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Last Name
    if (isset($_POST['account_last_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_last_name'])) {
        $errors->add('validation', __('Allowed characters for Last Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Display Name
    if (isset($_POST['account_display_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_display_name'])) {
        $errors->add('validation', __('Allowed characters for Display Name are alphabets and spaces only.', 'woocommerce'));
    }
}




add_action('woocommerce_after_save_address_validation', 'validate_billing_address_fields', 10, 2);

function validate_billing_address_fields($user_id, $address_type)
{
    if ('billing' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $billing_first_name = isset($_POST['billing_first_name']) ? sanitize_text_field($_POST['billing_first_name']) : '';
        $billing_last_name = isset($_POST['billing_last_name']) ? sanitize_text_field($_POST['billing_last_name']) : '';
        $billing_city = isset($_POST['billing_city']) ? sanitize_text_field($_POST['billing_city']) : '';
        $billing_address_1 = isset($_POST['billing_address_1']) ? sanitize_text_field($_POST['billing_address_1']) : '';

        $billing_postcode = isset($_POST['billing_postcode']) ? sanitize_text_field($_POST['billing_postcode']) : '';
        $billing_email = isset($_POST['billing_email']) ? sanitize_email($_POST['billing_email']) : '';

        // Validate Billing First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_first_name)) {
            $validation_errors[] = __('Allowed characters for Billing First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_last_name)) {
            $validation_errors[] = __('Allowed characters for Billing Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_city)) {
            $validation_errors[] = __('Allowed characters for Billing City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $billing_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $billing_postcode)) {
            $validation_errors[] = __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate Billing Email (Basic Email validation)
        if (!is_email($billing_email)) {
            $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}








add_action('woocommerce_after_save_address_validation', 'validate_shipping_address_fields', 10, 2);

function validate_shipping_address_fields($user_id, $address_type)
{
    if ('shipping' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $shipping_first_name = isset($_POST['shipping_first_name']) ? sanitize_text_field($_POST['shipping_first_name']) : '';
        $shipping_last_name = isset($_POST['shipping_last_name']) ? sanitize_text_field($_POST['shipping_last_name']) : '';
        $shipping_city = isset($_POST['shipping_city']) ? sanitize_text_field($_POST['shipping_city']) : '';
        $shipping_address_1 = isset($_POST['shipping_address_1']) ? sanitize_text_field($_POST['shipping_address_1']) : '';

        $shipping_postcode = isset($_POST['shipping_postcode']) ? sanitize_text_field($_POST['shipping_postcode']) : '';
        //  $shipping_email = isset($_POST['shipping_email']) ? sanitize_email($_POST['shipping_email']) : '';

        // Validate shipping First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_first_name)) {
            $validation_errors[] = __('Allowed characters for shipping First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_last_name)) {
            $validation_errors[] = __('Allowed characters for shipping Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_city)) {
            $validation_errors[] = __('Allowed characters for shipping City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $shipping_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $shipping_postcode)) {
            $validation_errors[] = __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate shipping Email (Basic Email validation)
        // if (!is_email($shipping_email)) {
        //     $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        // }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}




// validation woocommerce end --------------------



// Validate text fields (only alphabets allowed)
add_filter('wpcf7_validate_text', 'alpha_validation_filter_text', 20, 2);
add_filter('wpcf7_validate_text*', 'alpha_validation_filter_text', 20, 2);

function alpha_validation_filter_text($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('names' === $tag->name) {
        $name_of_the_input = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input)) {
            $result->invalidate($tag, "Allowed characters are Alphabets only.");
        }
    }

    return $result;
}

// Validate phone number (must be exactly 10 digits)
add_filter('wpcf7_validate_tel', 'numeric_phone_validation_filter', 20, 2);
add_filter('wpcf7_validate_tel*', 'numeric_phone_validation_filter', 20, 2);

function numeric_phone_validation_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('phone' === $tag->name) {
        $phone_number = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!preg_match('/^\d{8}$/', $phone_number)) {
            $result->invalidate($tag, "Phone number must contain exactly 8 digits.");
        }
    }

    return $result;
}



// Validate email (must be a valid email format)
add_filter('wpcf7_validate_email', 'validate_email_filter', 20, 2);
add_filter('wpcf7_validate_email*', 'validate_email_filter', 20, 2);

function validate_email_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('email' === $tag->name) {
        $email = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $result->invalidate($tag, "Please enter a valid email address.");
        }
    }

    return $result;
}


// Validate textarea field (message)
add_filter('wpcf7_validate_textarea', 'validate_textarea_filter', 20, 2);
add_filter('wpcf7_validate_textarea*', 'validate_textarea_filter', 20, 2);

function validate_textarea_filter($result, $tag)
{
    if (class_exists('WPCF7_FormTag')) {
        $tag = new WPCF7_FormTag($tag); // Corrected class
    }

    if ('message' === $tag->name) {
        $message = isset($_POST[$tag->name]) ? trim($_POST[$tag->name]) : '';

        // Allowed characters: alphabets, spaces, common punctuation marks
        if (!preg_match('/^[a-zA-Z0-9\s.,!?()-]+$/', $message)) {
            $result->invalidate($tag, "Message contains invalid characters. Only letters, numbers, spaces, and punctuation are allowed.");
        }

        // Min 10 characters, Max 500 characters
        if (strlen($message) < 10 || strlen($message) > 500) {
            $result->invalidate($tag, "Message must be between 10 and 500 characters.");
        }
    }

    return $result;
}




