<?php defined('ABSPATH') || exit; 
get_header('shop'); 
?> 

<div class="woocommerce-shop-banner pt-5">
    <div class="container">
        <div class="row g-md-3 align-items-center">
            <div class="col-md-12">
                <div class="banner-title text-center">
                    <p>BUY ONLINE, ANYTIME</p>
                    <?php if (is_product_category()) {
                        $category = get_queried_object();
                        if ($category) { ?>
                            <?php echo '<h1>' . esc_html($category->name) . '</h1>'; ?>
                        <?php } 
                    } else { ?>
                        <?php echo '<h1>Shop With Us</h1>' ?>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="woo-shop">
    <div class="container">
        <div class="row g-md-5 g-3">
            <div class="col-md-3">
                <div class="fiter_shop mb-4">
                    <div class="pb-4">
                        <h2 class="title"> Categories </h2>
                        <?php 
                        // Categories without "All"
                        echo do_shortcode('[product_categories_accordion hide_empty="0" parent="0" hide_empty="0" hide_empty_title="All"]'); 
                        ?>
                    </div>
                </div>
            </div>

            <div class="col-md-9">
                <div class="custom-product-grid" id="products">
                    <?php if (woocommerce_product_loop()): ?>
                        <?php 
                        do_action('woocommerce_before_shop_loop'); 
                        woocommerce_product_loop_start(); 

                        if (wc_get_loop_prop('total')) { 
                            while (have_posts()) { 
                                the_post(); 
                                do_action('woocommerce_shop_loop'); 
                                wc_get_template_part('content', 'product'); 
                            } 
                        } 

                        woocommerce_product_loop_end(); 
                        do_action('woocommerce_after_shop_loop'); 
                        ?>
                    <?php else: ?>
                        <?php do_action('woocommerce_no_products_found'); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php 
do_action('woocommerce_after_main_content'); 
get_footer('shop'); 
?>
