<?php

function hello_elementor_child_enqueue_styles()
{
    wp_enqueue_style('hello-elementor-parent-style', get_template_directory_uri() . '/../hello-elementor-child/style.css');
    wp_enqueue_style('hello-elementor-parent-ecommerce', get_template_directory_uri() . '/../hello-elementor-child/ecommerce.css');
}
add_action('wp_enqueue_scripts', 'hello_elementor_child_enqueue_styles');


// Enqueue Booststrap 
function enqueue_bootstrap()
{
    wp_enqueue_style('bootstrap-css', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css');
    wp_enqueue_script('bootstrap-js', 'https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.min.js', array('jquery'), null, true);

}
add_action('wp_enqueue_scripts', 'enqueue_bootstrap');


//  Slick carousel script and styles
function enqueue_slick_scripts()
{
    wp_enqueue_script('slick-js', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.js', array('jquery'), null, true);
    wp_enqueue_style('slick-css', 'https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.9.0/slick.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_slick_scripts');

function enqueue_glightbox_assets()
{
    // CSS
    wp_enqueue_style('glightbox-css', 'https://cdn.jsdelivr.net/npm/glightbox/dist/css/glightbox.min.css', array(), '3.2.0');

    // JS
    wp_enqueue_script('glightbox-js', 'https://cdn.jsdelivr.net/npm/glightbox/dist/js/glightbox.min.js', array(), '3.2.0', true);

    // Init Script
    wp_add_inline_script('glightbox-js', 'const lightbox = GLightbox({ selector: ".glightbox" });');
}
add_action('wp_enqueue_scripts', 'enqueue_glightbox_assets');

function enqueue_custom_script()
{
    wp_enqueue_script(
        'custom-script',
        get_template_directory_uri() . '../../hello-elementor-child/custom-script.js',
        array('jquery'),
        null,
        true
    );
}
add_action('wp_enqueue_scripts', 'enqueue_custom_script');



// custom code



// blog related start --------------------

function get_related_articles($post_id, $number_of_posts = 5)
{

    $args = array(
        'post_type' => 'post',
        'post__not_in' => array($post_id),
        'posts_per_page' => $number_of_posts,
        'ignore_sticky_posts' => 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );

    return get_posts($args);

    $related_posts = get_related_articles(get_the_ID());

    // If not enough related posts by category, get related posts by tag
    if (count($related_posts) < $number_of_posts) {
        $tags = wp_get_post_tags($post_id);
        if ($tags) {
            $tag_ids = array();
            foreach ($tags as $tag) {
                $tag_ids[] = $tag->term_id;
            }
            $args = array(
                'tag__in' => $tag_ids,
                'post__not_in' => array_merge(array($post_id), wp_list_pluck($related_posts, 'ID')),
                'posts_per_page' => $number_of_posts - count($related_posts),
                'ignore_sticky_posts' => 1,
            );
            $more_related_posts = get_posts($args);
            $related_posts = array_merge($related_posts, $more_related_posts);
        }
    }

    return $related_posts;
}

// blog related end --------------------




// woocommerce code start here ---------------------


//  WooCommerce product  image wrap  ----------
add_action('woocommerce_before_shop_loop_item_title', 'wrap_product_image_in_div', 5);
function wrap_product_image_in_div()
{
    echo '<div class="product-image-wrapper">';
}
add_action('woocommerce_before_shop_loop_item_title', 'close_product_image_div', 15);
function close_product_image_div()
{
    echo '</div>';
}
//  WooCommerce product image wrap ----------



function change_related_products_heading($translated_text, $text, $domain)
{
    if ('Related products' === $text) {
        $translated_text = __('Similar Products', 'your-text-domain');
    }
    return $translated_text;
}
add_filter('gettext', 'change_related_products_heading', 20, 3);






// product-categories start ----------------------------------------- 
function wpb_woocommerce_product_categories_accordion()
{
    // Get the current queried product category
    $queried_object = get_queried_object();
    $current_category_id = ($queried_object && isset($queried_object->term_id)) ? $queried_object->term_id : 0;

    // Get all parent categories of the current category
    $current_category_parents = [];
    if ($current_category_id) {
        $parent_categories = get_ancestors($current_category_id, 'product_cat');
        $current_category_parents = array_map('intval', $parent_categories);
    }

    // Recursive function to get subcategories with checkboxes
    function get_subcategories($parent_id, $level = 1, $current_category_id, $current_category_parents)
    {
        $args = array(
            'taxonomy' => 'product_cat',
            'orderby' => 'name',
            'order' => 'ASC',
            'parent' => $parent_id,
            'hide_empty' => true
        );
        $sub_categories = get_terms($args);

        if (!empty($sub_categories)) {
            echo '<ul class="list-unstyled ps-2">';
            foreach ($sub_categories as $sub_category) {
                $is_checked = ($sub_category->term_id == $current_category_id) ? 'checked' : '';
                $active_class = ($sub_category->term_id == $current_category_id) ? 'current-category' : '';

                echo '<li class="' . $active_class . '">';
                echo '<div class="in-menu">';
                echo '<input type="checkbox" class="category-checkbox me-2" data-category-id="' . $sub_category->term_id . '" ' . $is_checked . '> ';

                echo '<a href="' . get_term_link($sub_category) . '">  <span class="customcheck"></span>' . $sub_category->name . '</a>';
                echo '</div>';
                get_subcategories($sub_category->term_id, $level + 1, $current_category_id, $current_category_parents);
                echo '</li>';
            }
            echo '</ul>';
        }
    }

    // Get main product categories (parent categories)
    $args = array(
        'taxonomy' => 'product_cat',
        'orderby' => 'name',
        'order' => 'ASC',
        'parent' => 0,
        'hide_empty' => true
    );
    $product_categories = get_terms($args);

    if ($product_categories) {
        ob_start();
        ?>
                    <div class="accordion" id="productCategoriesAccordion">

                        <?php
                        $shop_page_url = wc_get_page_permalink('shop');
                        $is_shop_page = is_shop();
                        ?>                       


                        <?php
                        $i = 0;
                        foreach ($product_categories as $category) {
                            $i++;

                            // Check if the category has subcategories
                            $sub_args = array(
                                'taxonomy' => 'product_cat',
                                'parent' => $category->term_id,
                                'hide_empty' => true
                            );
                            $sub_categories = get_terms($sub_args);
                            $has_subcategories = !empty($sub_categories);

                            // Determine if this category should be expanded
                            $is_checked = ($category->term_id == $current_category_id) ? 'checked' : '';
                            $active_class = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'current-category' : '';
                            $show_collapse = ($category->term_id == $current_category_id || in_array($category->term_id, $current_category_parents)) ? 'show' : '';
                            ?>
                            <div class="accordion-item <?php echo $active_class; ?>">
                                <div class="accordion-header d-flex align-items-center" id="heading<?php echo $i; ?>">
                                    <label for="cat<?php echo $category->term_id; ?>">
                                        <a href="<?php echo get_term_link($category); ?>" class="main-category">
                                            <?php echo $category->name; ?>
                                        </a>

                                        <input type="checkbox" class="category-checkbox ms-2"
                                            id="cat<?php echo $category->term_id; ?>"
                                            data-category-id="<?php echo $category->term_id; ?>" <?php echo $is_checked; ?>>
                                    </label>



                                    <?php if ($has_subcategories) { ?>
                                        <button
                                            class="accordion-button ms-auto <?php echo ($show_collapse == '') ? 'collapsed' : ''; ?>"
                                            type="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo $i; ?>"
                                            aria-expanded="<?php echo ($show_collapse) ? 'true' : 'false'; ?>"
                                            aria-controls="collapse<?php echo $i; ?>"
                                            data-category-id="<?php echo $category->term_id; ?>">
                                            <i class="fa fa-angle-down"></i>
                                        </button>
                                    <?php } ?>
                                </div>
                                <?php if ($has_subcategories) { ?>
                                    <div id="collapse<?php echo $i; ?>"
                                        class="accordion-collapse collapse <?php echo $show_collapse; ?>"
                                        aria-labelledby="heading<?php echo $i; ?>" data-bs-parent="#productCategoriesAccordion">
                                        <div class="accordion-body ps-0 pe-0">
                                            <?php get_subcategories($category->term_id, 1, $current_category_id, $current_category_parents); ?>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                            <?php
                        }
                        ?>
                    </div>

                    <script>
                        document.addEventListener("DOMContentLoaded", function () {
                            // Load saved active category from localStorage
                            var activeCategory = localStorage.getItem("activeCategory");

                            if (activeCategory) {
                                document.querySelectorAll(".category-checkbox").forEach(cb => cb.checked = false);
                                var checkbox = document.querySelector('.category-checkbox[data-category-id="' + activeCategory + '"]');
                                if (checkbox) {
                                    checkbox.checked = true;
                                }
                            }

                            // Function: select category
                            function selectCategory(categoryId, link) {
                                // Sabhi uncheck
                                document.querySelectorAll(".category-checkbox").forEach(cb => cb.checked = false);

                                // Sirf current check
                                var current = document.querySelector('.category-checkbox[data-category-id="' + categoryId + '"]');
                                if (current) current.checked = true;

                                // Save active category
                                localStorage.setItem("activeCategory", categoryId);

                                // Redirect
                                if (link) {
                                    window.location.href = link;
                                }
                            }

                            // Checkbox change event
                            document.querySelectorAll(".category-checkbox").forEach(function (checkbox) {
                                checkbox.addEventListener("change", function (e) {
                                    var categoryId = this.getAttribute("data-category-id");
                                    var link = this.closest("label, .in-menu").querySelector("a").href;
                                    selectCategory(categoryId, link);
                                });
                            });

                            // Category name (anchor) click event
                            document.querySelectorAll(".accordion-header a.main-category, .in-menu a").forEach(function (anchor) {
                                anchor.addEventListener("click", function (e) {
                                    e.preventDefault(); // default redirect stop
                                    var categoryId = this.closest("label, .in-menu").querySelector(".category-checkbox").getAttribute("data-category-id");
                                    var link = this.href;
                                    selectCategory(categoryId, link);
                                });
                            });

                            // Accordion open/close save
                            document.querySelectorAll(".accordion-button").forEach(function (button) {
                                button.addEventListener("click", function () {
                                    var categoryId = this.getAttribute("data-category-id");
                                    if (document.querySelector(this.getAttribute("data-bs-target")).classList.contains("show")) {
                                        localStorage.removeItem("activeAccordion");
                                    } else {
                                        localStorage.setItem("activeAccordion", categoryId);
                                    }
                                });
                            });

                            // Restore accordion state
                            var activeAccordion = localStorage.getItem("activeAccordion");
                            if (activeAccordion) {
                                var activeBtn = document.querySelector('.accordion-button[data-category-id="' + activeAccordion + '"]');
                                if (activeBtn) {
                                    var collapseElement = activeBtn.getAttribute("data-bs-target");
                                    document.querySelector(collapseElement).classList.add("show");
                                    activeBtn.classList.remove("collapsed");
                                    activeBtn.setAttribute("aria-expanded", "true");
                                }
                            }
                        });
                        </script>



                    <style>
                        .current-category>a {
                            font-weight: bold;
                            color: #ff6600;
                        }

                        .category-checkbox {
                            display: inline-block !important;
                            margin-left: 6px;
                        }


                        span.customcheck {
                            background: #FFFFFF 0% 0% no-repeat padding-box;
                            border: 1px solid #B7DBEE;
                            border-radius: 5px;
                            width: 15px;
                            height: 15px;
                            position: relative;
                            margin-right: 6px;
                            margin-top: 0px;
                            top: 2px;
                            display: none;
                        }

                        .current-category [type=checkbox]:checked~a span.customcheck {
                            background: #326783;
                            border-color: #326783;
                        }

                        .current-category [type=checkbox]~a .customcheck:after {
                            content: "";
                            position: absolute;
                        }

                        .current-category a input:checked~.customcheck:after {
                            display: block;
                        }

                        .current-category a .customcheck:after {
                            left: 5px;
                            top: 2px;
                            width: 4px;
                            height: 8px;
                            border: solid white;
                            border-width: 0 2px 2px 0;
                            -webkit-transform: rotate(45deg);
                            -ms-transform: rotate(45deg);
                            transform: rotate(45deg);
                        }

                        /* Category list items ek hi line me flex ho */
                        .accordion-header label,
                        .in-menu {
                            display: flex;
                            justify-content: space-between; /* name left, checkbox right */
                            align-items: center;
                            width: 100%;
                        }

                        /* Anchor left side rhe */
                        .accordion-header label a,
                        .in-menu a {
                            flex: 1;
                            text-decoration: none;
                            color: inherit;
                        }

                        /* Checkbox right side fix ho */
                        .category-checkbox {
                            margin-left: auto !important;
                            flex-shrink: 0;
                        }



                        /* Category list items ek hi line me flex ho */
                        .accordion-header label,
                        .in-menu {
                            display: flex;
                            justify-content: space-between; /* name left, checkbox right */
                            align-items: center;
                            width: 100%;
                        }

                        /* Anchor left side rhe */
                        .accordion-header label a,
                        .in-menu a {
                            flex: 1;
                            text-decoration: none;
                            color: inherit;
                        }

                        /* Checkbox right side fix ho */
                        .category-checkbox {
                            margin-left: auto !important;
                            flex-shrink: 0;
                        }


/* Base style for round checkbox */
.category-checkbox {
  appearance: none;
  -webkit-appearance: none;
  width: 20px;
  height: 20px;
  border: 2px solid #2C302E;
  border-radius: 50%;
  display: inline-block;
  position: relative;
  cursor: pointer;
  outline: none;
  background: transparent;
  vertical-align: middle;
  transition: all 0.2s ease-in-out;
}

/* Active (checked) state */
.category-checkbox:checked {
  border-color: #AD986C;
  background: #AD986C;   /* poora fill */
}

/* Inner gap (white circle inside) */
.category-checkbox:checked::after {
  content: "";
  width: 8px;   /* inner gap size */
  height: 8px;
  background: #fff;   /* ya transparent agar background same ho */
  border-radius: 50%;
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
}



                    </style>
                    <?php
                    return ob_get_clean();
    }
}

add_shortcode('product_categories_accordion', 'wpb_woocommerce_product_categories_accordion');


function custom_woocommerce_pagination_only() {
    global $wp_query;

    if ($wp_query->max_num_pages <= 1) return; 

    ?>
    <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
        <div class="pagination-style-one">
            <?php
            echo paginate_links(array(
                'total'   => $wp_query->max_num_pages,
                'current' => max(1, get_query_var('paged')),
                'format'  => '?paged=%#%',
                'show_all' => false,
                'type'     => 'plain',
                'prev_text' => '<i class="eicon-caret-left"></i>',
                'next_text' => '<i class="eicon-caret-right"></i>',
                'end_size' => 2,
                'mid_size' => 2
            ));
            ?>
        </div>
    </div>
    <?php
}
remove_action('woocommerce_after_shop_loop', 'woocommerce_pagination', 10);
add_action('woocommerce_after_shop_loop', 'custom_woocommerce_pagination_only', 10);


// product category for sidebar end -------------------------------





// brand filter -------------------
function brand_checkbox_filter_shortcode() {
    $terms = get_terms(array(
        'taxonomy' => 'product_brand',
        'hide_empty' => true,
    ));

    if (empty($terms) || is_wp_error($terms)) {
        return '<p>No brands available.</p>';
    }

    $selected = isset($_GET['product_brand']) ? (array) $_GET['product_brand'] : [];

    ob_start();
    ?>
    <form method="GET" id="brand-filter-form" class="brand-filter-form">
        <div class="brand-filter-checkboxes">
            <?php foreach ($terms as $term): ?>
                <label>
                    
                   <p class="mb-0 d-inline">  <?php echo esc_html($term->name); ?> </p> 
                    <input type="checkbox" name="product_brand[]" value="<?php echo esc_attr($term->slug); ?>"
                        <?php checked(in_array($term->slug, $selected)); ?>
                        onchange="this.form.submit()">
                        <span class="customcheckbox"> </span>
                </label>
            <?php endforeach; ?>
        </div>
    </form>
    <?php
    return ob_get_clean();
}
add_shortcode('brand_checkbox_filter', 'brand_checkbox_filter_shortcode');

function apply_brand_checkbox_filter_to_products($query) {
    if (!is_admin() && $query->is_main_query() && is_post_type_archive('product')) {
        if (!empty($_GET['product_brand']) && is_array($_GET['product_brand'])) {
            $brands = array_map('sanitize_text_field', $_GET['product_brand']);

            $query->set('tax_query', array(array(
                'taxonomy' => 'product_brand',
                'field'    => 'slug',
                'terms'    => $brands,
                'operator' => 'IN',
            )));
        }
    }
}
add_action('pre_get_posts', 'apply_brand_checkbox_filter_to_products');
// brand filter end -------------------







// Add custom quantity buttons JS start -----------

add_action('wp_footer', 'custom_quantity_buttons_script');
function custom_quantity_buttons_script()
{
    if (!is_product())
        return;
    ?>
                <script>
                    document.addEventListener('DOMContentLoaded', function () {
                        const qtyContainers = document.querySelectorAll('.quantity');
                        qtyContainers.forEach(qty => {
                            const input = qty.querySelector('input.qty');
                            if (!input) return;

                            // Remove existing buttons (if any)
                            if (qty.querySelector('.custom-plus')) return;

                            // Create buttons
                            const minus = document.createElement('button');
                            minus.type = 'button';
                            minus.innerHTML = '−';
                            minus.className = 'custom-minus';

                            const plus = document.createElement('button');
                            plus.type = 'button';
                            plus.innerHTML = '+';
                            plus.className = 'custom-plus';

                            // Insert buttons
                            qty.insertBefore(minus, input);
                            qty.appendChild(plus);

                            // Event listeners
                            minus.addEventListener('click', () => {
                                if (input.value > 1) input.value = parseInt(input.value) - 1;
                            });
                            plus.addEventListener('click', () => {
                                input.value = parseInt(input.value) + 1;
                            });
                        });
                    });
                </script>
                <?php
}

// Add custom quantity buttons JS end --------------




// single shop banner  start ---------------------------
// Remove default breadcrumb location
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);

// Add breadcrumb before product title
add_action('woocommerce_single_product_summary', 'woocommerce_breadcrumb', 4);


add_action('woocommerce_before_main_content', 'custom_shop_header', 5);
function custom_shop_header() {
    if (is_product()) {
        ?>
        <div class="woocommerce-shop-banner pt-md-5 pb-md-5 pt-4 pb-4 bg-light">
            <div class="container">
                <div class="row g-md-3 align-items-center">
                    <div class="col-md-12">
                        <div class="banner-title text-center">
                            <?php
                            // Display product category name if applicable
                            if (is_product_category()) {
                                $category = get_queried_object();
                                if ($category) {
                                    echo '<h1>' . esc_html($category->name) . '</h1>';
                                }
                            } else {
                                echo '<h1>Shop</h1>';
                            }

                            // Display WooCommerce breadcrumb
                            if (function_exists('woocommerce_breadcrumb')) {
                                woocommerce_breadcrumb(array(
                                    'delimiter'   => ' / ',
                                    'wrap_before' => '<nav class="woocommerce-breadcrumb" itemprop="breadcrumb">',
                                    'wrap_after'  => '</nav>',
                                ));
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
// single shop banner end ---------------------------



// wpgis  product gallery ------------------
add_action('wp_footer', 'hide_gallery_thumbs_if_single_image');
function hide_gallery_thumbs_if_single_image()
{
    if (is_product()): ?>
                    <script>
                        jQuery(document).ready(function ($) {
                            $(window).on('load', function () {
                                var thumbCount = $('.wpgis-slider-nav .slick-slide').length;

                                if (thumbCount <= 1) {
                                    $('.wpgis-slider-nav').hide();
                                    $('.wpgis-slider-for').addClass('full-width-slider');
                                } else {
                                    $('.wpgis-slider-nav').show();
                                    $('.wpgis-slider-for').removeClass('full-width-slider');
                                }
                            });
                        });
                    </script>
                <?php endif;
}
// wpgis  product gallery end ------------------








// validation start -----------------------------------------------------------



// validation woocommerce start 


add_action('woocommerce_save_account_details_errors', 'validate_my_account_fields', 10, 1);

function validate_my_account_fields($errors)
{
    // Validate First Name
    if (isset($_POST['account_first_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_first_name'])) {
        $errors->add('validation', __('Allowed characters for First Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Last Name
    if (isset($_POST['account_last_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_last_name'])) {
        $errors->add('validation', __('Allowed characters for Last Name are alphabets and spaces only.', 'woocommerce'));
    }

    // Validate Display Name
    if (isset($_POST['account_display_name']) && !preg_match('/^[a-zA-Z\s]+$/', $_POST['account_display_name'])) {
        $errors->add('validation', __('Allowed characters for Display Name are alphabets and spaces only.', 'woocommerce'));
    }
}




add_action('woocommerce_after_save_address_validation', 'validate_billing_address_fields', 10, 2);

function validate_billing_address_fields($user_id, $address_type)
{
    if ('billing' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $billing_first_name = isset($_POST['billing_first_name']) ? sanitize_text_field($_POST['billing_first_name']) : '';
        $billing_last_name = isset($_POST['billing_last_name']) ? sanitize_text_field($_POST['billing_last_name']) : '';
        $billing_city = isset($_POST['billing_city']) ? sanitize_text_field($_POST['billing_city']) : '';
        $billing_address_1 = isset($_POST['billing_address_1']) ? sanitize_text_field($_POST['billing_address_1']) : '';

        $billing_postcode = isset($_POST['billing_postcode']) ? sanitize_text_field($_POST['billing_postcode']) : '';
        $billing_email = isset($_POST['billing_email']) ? sanitize_email($_POST['billing_email']) : '';

        // Validate Billing First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_first_name)) {
            $validation_errors[] = __('Allowed characters for Billing First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_last_name)) {
            $validation_errors[] = __('Allowed characters for Billing Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Billing Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $billing_city)) {
            $validation_errors[] = __('Allowed characters for Billing City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $billing_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $billing_postcode)) {
            $validation_errors[] =  __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate Billing Email (Basic Email validation)
        if (!is_email($billing_email)) {
            $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}








add_action('woocommerce_after_save_address_validation', 'validate_shipping_address_fields', 10, 2);

function validate_shipping_address_fields($user_id, $address_type)
{
    if ('shipping' === $address_type) {
        // Initialize an array to store error messages
        $validation_errors = [];

        // Get the values of the fields from the form
        $shipping_first_name = isset($_POST['shipping_first_name']) ? sanitize_text_field($_POST['shipping_first_name']) : '';
        $shipping_last_name = isset($_POST['shipping_last_name']) ? sanitize_text_field($_POST['shipping_last_name']) : '';
        $shipping_city = isset($_POST['shipping_city']) ? sanitize_text_field($_POST['shipping_city']) : '';
        $shipping_address_1 = isset($_POST['shipping_address_1']) ? sanitize_text_field($_POST['shipping_address_1']) : '';

        $shipping_postcode = isset($_POST['shipping_postcode']) ? sanitize_text_field($_POST['shipping_postcode']) : '';
      //  $shipping_email = isset($_POST['shipping_email']) ? sanitize_email($_POST['shipping_email']) : '';

        // Validate shipping First Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_first_name)) {
            $validation_errors[] = __('Allowed characters for shipping First Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_last_name)) {
            $validation_errors[] = __('Allowed characters for shipping Last Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate shipping Last Name (Only alphabets and spaces allowed)
        if (!preg_match('/^[a-zA-Z\s]+$/', $shipping_city)) {
            $validation_errors[] = __('Allowed characters for shipping City Name are alphabets and spaces only.', 'woocommerce');
        }

        // Validate Address (Only letters, numbers, and spaces)
        if (!preg_match('/^[a-zA-Z0-9\s]+$/', $shipping_address_1)) {
            $validation_errors[] = __('Address must contain only letters, numbers, and spaces.', 'woocommerce');
        }

        // Validate Postcode (Only numbers, 4-10 digits)
        if (!preg_match('/^\d{4,6}$/', $shipping_postcode)) {
            $validation_errors[] =  __('Postcode must be a number between 4 and 6 digits.', 'woocommerce');
        }



        // Validate shipping Email (Basic Email validation)
        // if (!is_email($shipping_email)) {
        //     $validation_errors[] = __('Please enter a valid email address.', 'woocommerce');
        // }

        // If there are validation errors, stop the form submission and display the errors
        if (!empty($validation_errors)) {
            // Add all validation errors as WooCommerce notices
            foreach ($validation_errors as $error_message) {
                wc_add_notice($error_message, 'error');  // Add error messages
            }

            // Stop the form submission by returning early
            return; // This will prevent the address from being saved
        }
    }
}




// validation woocommerce end --------------------







// contact form validation 

// Validate text fields (only alphabets allowed)
add_filter( 'wpcf7_validate_text', 'alpha_validation_filter_text', 20, 2 );
add_filter( 'wpcf7_validate_text*', 'alpha_validation_filter_text', 20, 2 );

function alpha_validation_filter_text( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'names' === $tag->name ) {
        $name_of_the_input = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input) ) {
            $result->invalidate( $tag, "Allowed characters are Alphabets only." );
        }
    }

    if ( 'lname' === $tag->name ) {
        $name_of_the_input = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! preg_match('/^[a-zA-Z\s]+$/', $name_of_the_input) ) {
            $result->invalidate( $tag, "Allowed characters are Alphabets only." );
        }
    }

    return $result;
}

// Validate phone number (must be exactly 10 digits)
add_filter( 'wpcf7_validate_tel', 'numeric_phone_validation_filter', 20, 2 );
add_filter( 'wpcf7_validate_tel*', 'numeric_phone_validation_filter', 20, 2 );

function numeric_phone_validation_filter( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'phone' === $tag->name ) {
        $phone_number = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! preg_match( '/^\d{8}$/', $phone_number ) ) {
            $result->invalidate( $tag, "Phone number must contain exactly 8 digits." );
        }
    }

    return $result;
}



// Validate email (must be a valid email format)
add_filter( 'wpcf7_validate_email', 'validate_email_filter', 20, 2 );
add_filter( 'wpcf7_validate_email*', 'validate_email_filter', 20, 2 );

function validate_email_filter( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'email' === $tag->name ) {
        $email = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        if ( ! filter_var( $email, FILTER_VALIDATE_EMAIL ) ) {
            $result->invalidate( $tag, "Please enter a valid email address." );
        }
    }

    return $result;
}


// Validate textarea field (message)
add_filter( 'wpcf7_validate_textarea', 'validate_textarea_filter', 20, 2 );
add_filter( 'wpcf7_validate_textarea*', 'validate_textarea_filter', 20, 2 );

function validate_textarea_filter( $result, $tag ) {
    if ( class_exists( 'WPCF7_FormTag' ) ) {
        $tag = new WPCF7_FormTag( $tag ); // Corrected class
    }

    if ( 'message' === $tag->name ) {
        $message = isset( $_POST[$tag->name] ) ? trim( $_POST[$tag->name] ) : '';

        // Allowed characters: alphabets, spaces, common punctuation marks
        if ( ! preg_match( '/^[a-zA-Z0-9\s.,!?()-]+$/', $message ) ) {
            $result->invalidate( $tag, "Message contains invalid characters. Only letters, numbers, spaces, and punctuation are allowed." );
        }

        // Min 10 characters, Max 500 characters
        if ( strlen( $message ) < 10 || strlen( $message ) > 500 ) {
            $result->invalidate( $tag, "Message must be between 10 and 500 characters." );
        }
    }

    return $result;
}




// validation end -----------------------------------------------------------



// promotion page start ------------------------------------------------------------


function display_promotion($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 9,
        ),
        $atts,
        'promotion'
    );

    // Get the current page


    $args = array(
        'post_type' => 'promotion',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );


    $promotion_query = new WP_Query($args);

    ob_start();

    if ($promotion_query->have_posts()): ?>
        <div class="promotion-main">
            <div class="row gy-md-5 gx-md-4 g-3">
                <?php while ($promotion_query->have_posts()):
                    $promotion_query->the_post();
                    ?>
                <div class="col-md-4">
                        <a href="<?php the_permalink(); ?>">
                            <div class="portfolio-box">
                                <div class="portfolio-img">
                                <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        } ?>
                                </div>
                                <div class="portfolio-info p-4">
                                    <h1 class="title m-0"> <?php echo get_the_title(); ?> </h1>
                                    <p class="excerpt mb-0"> <?php echo get_the_excerpt(); ?> </p>
                                </div>
                                <div class="overlay">
                                    <img src="https://draftsite1.com/goldcard/wp-content/uploads/2025/08/icon-plus-circle.svg" alt="" width="70">
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endwhile; ?>
            </div>

            <?php if ($promotion_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-style-one">
                        <?php
                        echo paginate_links(array(
                            'total' => $promotion_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => '<i class="eicon-caret-left"></i>',
                            'next_text' => '<i class="eicon-caret-right"></i>',
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>
            <?php endif; ?>


        <?php else:
        echo 'No promotion found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('promotion', 'display_promotion');


function display_related_promotion($post_id)
{
   
    $args = array(
        'post_type' => 'promotion',
        'posts_per_page' => 3,
        'post__not_in' => array($post_id),
        'orderby' => 'rand', 
    );

    $related_query = new WP_Query($args);

    ob_start();

    if ($related_query->have_posts()): ?>


<div class="related-promotions">
    <div class="container">
        <div class="row gy-md-5 gx-md-4 g-3">
            <div class="col-12">
                <h2>Other Ongoing Promotions</h2>
            </div>

        <?php while ($related_query->have_posts()):
            $related_query->the_post(); ?>
             <div class="col-md-4">
                        <a href="<?php the_permalink(); ?>">
                            <div class="portfolio-box">
                                <div class="portfolio-img">
                                <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        } ?>
                                </div>
                                <div class="portfolio-info p-4">
                                    <h1 class="title m-0"> <?php echo get_the_title(); ?> </h1>
                                    <p class="excerpt mb-0"> <?php echo get_the_excerpt(); ?> </p>
                                </div>
                                <div class="overlay">
                                    <img src="https://draftsite1.com/goldcard/wp-content/uploads/2025/08/icon-plus-circle.svg" alt="" width="70">
                                </div>
                            </div>
                        </a>
                    </div>
        <?php endwhile; ?>

        </div>
        </div>
        </div>


    <?php else:
        echo 'No related promotion found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}



// promotion list end------------



// events 



function display_events($atts)
{
    // Attributes
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 6,
        ),
        $atts,
        'events'
    );

    // Get the current page


    $args = array(
        'post_type' => 'events',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => get_query_var('paged') ? get_query_var('paged') : 1,
        'orderby' => 'date',
        'order' => 'DESC',
    );


    $events_query = new WP_Query($args);

    ob_start();

    if ($events_query->have_posts()): ?>
        <div class="events-main">
            <div class="row gy-md-5 gx-md-4 g-3">
                <?php while ($events_query->have_posts()):
                    $events_query->the_post();
                    ?>
                       <div class="col-md-4">
                    <a href="<?php the_permalink(); ?>">
                        <div class="event-box">
                            <div class="event-img">
                            <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        } ?>
                                    <div class="overlay">
                                <img src="https://draftsite1.com/goldcard/wp-content/uploads/2025/08/icon-plus-circle.svg" alt="" width="60">
                            </div>
                            </div>
                            <div class="event-info py-4">
                                <h1 class="title m-0"> <?php echo get_the_title(); ?>  </h1>                                
                            </div>
                            
                        </div>
                    </a>
                </div>

              
                <?php endwhile; ?>
            </div>

            <?php if ($events_query->max_num_pages > 1): ?>
                <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                    <div class="pagination-style-one">
                        <?php
                        echo paginate_links(array(
                            'total' => $events_query->max_num_pages,
                            'current' => max(1, get_query_var('paged')),
                            'format' => '?paged=%#%',
                            'show_all' => false,
                            'type' => 'plain',
                            'prev_text' => '<i class="eicon-caret-left"></i>',
                            'next_text' => '<i class="eicon-caret-right"></i>',
                            'end_size' => 2,
                            'mid_size' => 2
                        ));
                        ?>
                    </div>
                </div>
            <?php endif; ?>


        <?php else:
        echo 'No events found.';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('events', 'display_events');

// end events -----------

function load_event_gallery_callback() { 
    $post_id = intval($_POST['post_id']);
    $paged   = intval($_POST['paged']);
    $per_page = 9;

    $images = get_field('gallery_images', $post_id);
    $total_images = count($images);
    $total_pages  = ceil($total_images / $per_page);

    $offset = ($paged - 1) * $per_page;
    $paged_images = array_slice($images, $offset, $per_page);

    ob_start();
    foreach ($paged_images as $image): ?>
        <div class="col-md-4">
        <div class="event-box">
            <div class="event-img">
                <a href="<?php echo esc_url($image['url']); ?>" class="glightbox" data-gallery="acf-gallery"
                    data-title="<?php echo esc_attr($image['title']); ?>">
                    <img src="<?php echo esc_url($image['url']); ?>"
                        alt="<?php echo esc_attr($image['alt']); ?>" class="w-100">
                    <div class="overlay">
                        <img src="https://draftsite1.com/goldcard/wp-content/uploads/2025/08/icon-plus-circle.svg"
                            alt="" width="60">
                    </div>
                </a>
            </div>
        </div>
    </div>
    <?php endforeach;
    $html = ob_get_clean();

    // Pagination again
    $pagination = paginate_links(array(
        'base'      => '%_%',
        'format'    => '#page=%#%',
        'current'   => $paged,
        'total'     => $total_pages,
        'prev_text' => '<i class="eicon-caret-left"></i>',
        'next_text' => '<i class="eicon-caret-right"></i>',
        'end_size'  => 2,
        'mid_size'  => 2,
    ));

    wp_send_json(array(
        'html' => $html,
        'pagination' => $pagination
    ));
} 
add_action('wp_ajax_load_event_gallery', 'load_event_gallery_callback');
add_action('wp_ajax_nopriv_load_event_gallery', 'load_event_gallery_callback');


function enqueue_gallery_ajax() {
    wp_enqueue_script('gallery-ajax', get_stylesheet_directory_uri() . '../../hello-elementor-child/gallery-ajax.js', array('jquery'), null, true);
    wp_localize_script('gallery-ajax', 'gallery_ajax', array(
        'ajaxurl' => admin_url('admin-ajax.php'),
        'post_id' => get_the_ID(),
    ));
}
add_action('wp_enqueue_scripts', 'enqueue_gallery_ajax');



// teampage start ------------------------------------------------------------






function display_team($atts)
{
    $atts = shortcode_atts(
        array(
            'posts_per_page' => 11,
        ),
        $atts,
        'team'
    );

    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

    $args = array(
        'post_type' => 'our-team',
        'posts_per_page' => $atts['posts_per_page'],
        'paged' => $paged,
    );

    $team_query = new WP_Query($args);

    ob_start();

    if ($team_query->have_posts()): ?>
        <div class="teampage mt-0 team-main">
            <div class="row m-0 g-md-0 g-3" id="team-container">
            <?php 
            $slide_index = 0; 
            while ($team_query->have_posts()):
                $team_query->the_post();
            ?>
                <div class="col-md-3 p-0">                    
                    <div class="event-box rounded-0" 
                        data-bs-toggle="modal" 
                        data-bs-target="#teamModal" 
                        data-index="<?php echo $slide_index; ?>">
                        <div class="event-img rounded-0">
                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail('full', array('class' => 'd-block w-100'));
                            } ?>
                            <div class="event-text">
                                <h5><?php echo get_the_title(); ?></h5>
                                <?php if ($position = get_field('position')): ?>
                                    <p class="position"><?php echo $position; ?></p>
                                <?php endif; ?>
                            </div>
                            <div class="overlay">
                                <img src="https://draftsite1.com/goldcard/wp-content/uploads/2025/08/icon-plus-circle.svg" alt="" width="60">
                            </div>
                        </div>                            
                    </div>                    
                </div> 
            <?php 
            $slide_index++; 
            endwhile; 
            ?>

                
                <!-- Join Us box -->
                <div class="col-md-3 p-0">
                    <div class="Join-us">
                        <div>
                            <p>This could be <br> <span>YOU</span></p>
                            <a class="elementor-button elementor-button-link elementor-size-sm" href="https://draftsite1.com/goldcard/about/">
                                <span class="elementor-button-content-wrapper">
                                    <span class="elementor-button-icon">
                                        <!-- Your SVG -->
                                    </span>
                                    <span class="elementor-button-text">JOIN US</span>
                                </span>
                            </a>
                        </div>
                    </div>
                </div> 
            </div>
        </div>
    <?php else:
        echo 'No team found.';
    endif; ?>


    <!-- Global Modal with Carousel -->
    <div class="modal fade teamModal" id="teamModal" tabindex="-1">
      <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
        <div class="modal-body p-0 rounded-3">
                    <button type="button" class="btn-close" data-bs-dismiss="modal">
                        <img src="https://draftsite1.com/goldcard/wp-content/uploads/2025/08/icon-x.svg" alt="" width="20">
                    </button>

            <div id="teamCarousel" class="carousel slide" data-bs-ride="false">
              <div class="carousel-inner">

                <?php 
                $i = 0; 
                $team_query->rewind_posts(); 
                while ($team_query->have_posts()):
                    $team_query->the_post(); 
                    ?>
                  <div class="carousel-item <?php if ($i==0) echo 'active'; ?>">
                    <div class="row">
                        <div class="col-md-5">
                        <div class="team-member">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                } ?>

                                <div class="member-social">
                                    <?php $instagram = get_field('instagram'); ?>
                                    <a href="<?php echo esc_url($instagram); ?>" target="_blank" class="social-icon">
                                        <i class="fab fa-instagram"></i>
                                    </a>
                                    <?php $facebook = get_field('facebook'); ?>
                                    <a href="<?php echo esc_url($facebook); ?>"  target="_blank" class="social-icon">
                                        <i class="fab fa-linkedin"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-7 p-5">
                        <div class="team-details">
                                                <div class="team-header">
                                                    <h2><?php echo get_the_title(); ?> </h2>
                                                    <?php
                                            $position = get_field('position');
                                            if ($position):
                                                echo '<span>';
                                                echo $position;
                                                echo '</span>';
                                            endif; ?> 
                                                </div> 
                                                <p class="mb-4">
                                                <?php echo get_the_content(); ?>
                                                </p> 
                                                <div class="team-contact">

                                                <?php
                                                $email = get_field('email');
                                                if ($email):
                                                    echo '<p> <i class="fa fa-envelope"></i> &nbsp;';
                                                    echo $email;
                                                    echo '</p>';
                                                endif; ?> 

                                            <?php
                                                $phone = get_field('phone');
                                                if ($phone):
                                                    echo '<p> <i class="fa fa-phone-alt"></i>&nbsp;';
                                                    echo $phone;
                                                    echo '</p>';
                                                endif; ?> 
                                                    </div>
                                             </div>
                        </div>
                    </div>
                  </div>
                <?php $i++; endwhile; ?>

              </div>

                <button class="carousel-control-prev" type="button" data-bs-target="#teamCarousel" data-bs-slide="prev">
                    <img src="https://draftsite1.com/goldcard/wp-content/uploads/2025/08/arrow-next.svg" alt="" style="scale: -1" width="18">
                </button>
                <button class="carousel-control-next" type="button" data-bs-target="#teamCarousel" data-bs-slide="next">
                    <img src="https://draftsite1.com/goldcard/wp-content/uploads/2025/08/arrow-next.svg" alt="" width="18">
                </button>
          
            </div>
            </div>
        </div>
      </div>
    </div>


    <?php if ($team_query->max_num_pages > 1): ?>
        <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
            <div class="pagination-style-one">
                <?php
                echo paginate_links(array(
                    'total' => $team_query->max_num_pages,
                    'current' => max(1, get_query_var('paged')),
                    'format' => '?paged=%#%',
                    'prev_text' => '<i class="eicon-caret-left"></i>',
                    'next_text' => '<i class="eicon-caret-right"></i>',
                ));
                ?>
            </div>
        </div>
    <?php endif; ?>

    <script>
document.addEventListener("DOMContentLoaded", function () {
  const cards = document.querySelectorAll('.event-box');
  const teamCarousel = document.querySelector('#teamCarousel');

  cards.forEach(card => {
    card.addEventListener('click', function () {
      let index = this.getAttribute('data-index');
      let bsCarousel = bootstrap.Carousel.getOrCreateInstance(teamCarousel);
      bsCarousel.to(index); // open clicked slide
    });
  });
});
</script>



    <?php
    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('team', 'display_team');



// teampage end ------------------------------------------------------------


// Change Related Products Heading
add_filter( 'woocommerce_product_related_products_heading', 'custom_related_products_title' );

function custom_related_products_title( $heading ) {
    return 'You May Like These, Too'; 
}










// Corporate Mobile & Business Broadband page image popup start

function custom_carousel_lightbox() {
    ?>
    <style>
    .img-lightbox-overlay {
      display: none;
      position: fixed;
      z-index: 99999;
      top: 0; left: 0;
      width: 100%; height: 100%;
      background: rgba(0,0,0,0.8);
      justify-content: center;
      align-items: center;
    }
    .img-lightbox-overlay img {
      max-width: 95%;
      max-height: 95%;
      border-radius: 8px;
      box-shadow: 0 0 20px rgba(0,0,0,0.6);
    }
    </style>

    <script>
    document.addEventListener("DOMContentLoaded", function () {
      // overlay create
      const overlay = document.createElement("div");
      overlay.classList.add("img-lightbox-overlay");
      overlay.innerHTML = "<img src='' alt=''>";
      document.body.appendChild(overlay);

      const overlayImg = overlay.querySelector("img");

      // carousel images click
      document.querySelectorAll(".owce-carousel img").forEach(img => {
        img.style.cursor = "zoom-in";
        img.addEventListener("click", () => {
          // agar srcset hai to last wala (largest) image lo
          let bigImg = img.getAttribute("srcset");
          if (bigImg) {
            let parts = bigImg.split(",");
            bigImg = parts[parts.length - 1].trim().split(" ")[0];
          } else {
            bigImg = img.src;
          }

          overlayImg.src = bigImg;
          overlay.style.display = "flex";
        });
      });

      // close on overlay click
      overlay.addEventListener("click", () => {
        overlay.style.display = "none";
      });
    });
    </script>
    <?php
}
add_action('wp_footer', 'custom_carousel_lightbox');

// Corporate Mobile & Business Broadband page image popup end
