<?php get_header(); ?>

<div class="single-detail">

    <div class="container">
        <?php
        if (have_posts()):
            while (have_posts()):
                the_post();
                ?>
                <div class="row py-5 mb-5 justify-content-between">
                    <div class="col-12">

                        <?php

                        function custom_breadcrumbs()
                        {
                            // Get the post object
                            global $post;

                            // Start the breadcrumb HTML
                            $breadcrumbs = '<div class="breadcrumbs-article mb-5">';

                            // Home link
                            $breadcrumbs .= '<a href="' . home_url() . '">Home</a> / ';

                            // Articles link
                            $breadcrumbs .= '<a href="' . get_permalink(get_page_by_path('promotions')) . '">Promotions</a> / ';

                            // Post title
                            if (is_single()) {
                                $breadcrumbs .= get_the_title();
                            }

                            // Close the breadcrumb HTML
                            $breadcrumbs .= '</div>';

                            echo $breadcrumbs;
                        }

                        ?>
                        <?php custom_breadcrumbs(); ?>

                       
                    </div>

                    <div class="col-md-6">
                        <div class="img-wrap">
                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail('full', array('class' => 'd-block w-100'));
                            } ?>
                        </div>
                    </div>

                    <div class="col-md-6 ps-lg-5">
                        <div class="portfolio-details">
                            <h3 class="pb-3"><?php echo the_title(); ?> </h3>

                            <?php
                            $offers = get_field('offers');
                            if ($offers):
                                echo '<p class="sub">';
                                echo $offers;
                                echo '</p>';
                            endif; ?>


                            <p> <?php the_content(); ?> </p>

                            <div class="btnlight">
                                <?php
                                $links = get_field('button_link');
                                if ($links) {
                                    $link_url = $links['url'];
                                    $link_title = $links['title'];
                                    ?>
                                    <a href="<?php echo esc_url($link_url); ?>"
                                        class="elementor-button" mt-4><?php echo esc_html($link_title); ?> </a>
                                <?php } ?>
                            </div>

                            
                        </div>
                    </div>


                </div>

                <?php
            endwhile;
        else:
            echo 'No post found.';
        endif;
        ?>

    </div>

</div>

<?php echo display_related_promotion(get_the_ID()); ?>


<?php get_footer(); ?>