<?php get_header(); ?>
<?php echo do_shortcode('[hfe_template id="2331"]'); ?>

<div class="article-detail">

    <div class="container pt-4">


        <div class="row g-md-5 g-3 justify-content-between">

            <div class="col-lg-8 col-md-8 order-md-1 order-2">
                <?php
                if (have_posts()):
                    while (have_posts()):
                        the_post();
                        ?>
                        <div class="content-area">
                            <div class="blog-post-card">
                                <div class="blog-image-wrapper">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        } ?>
                                    </a>
                                    <?php
                                    $terms = get_the_terms(get_the_ID(), 'category');
                                    if ($terms && !is_wp_error($terms)) { ?>
                                        <?php
                                        foreach ($terms as $term) {
                                            $category_name = strtolower($term->name); ?>

                                            <span class="blog-category-badge"><?php echo $category_name; ?></span>

                                            <?php
                                        } ?>
                                    <?php }
                                    ?>
                                </div>
                                <div class="blog-content">
                                    <h2><?php echo get_the_title(); ?></h2>
                                    <div>
                                        <?php the_content(); ?>
                                    </div>
                                </div>
                            </div>
                            <hr class="sidebar-divider" />

                            <div class="prevnext-post">
                                <div class="row">

                                    <!-- Previous Post -->
                                    <div class="col-md-6">
                                        <?php $prev_post = get_previous_post(); ?>
                                        <?php if (!empty($prev_post)): ?>
                                            <div class="after-post radius-left d-flex">
                                                <a href="<?php echo get_permalink($prev_post); ?>" class="me-2"
                                                    style="flex-shrink: 0;">
                                                    <?php
                                                    if (has_post_thumbnail($prev_post)) {
                                                        echo get_the_post_thumbnail($prev_post, 'thumbnail', ['style' => 'width: 80px; height: auto;']);
                                                    } else {
                                                        echo '<img src="' . esc_url(get_template_directory_uri() . '/assets/img/default-thumb.jpg') . '" style="width: 80px; height: auto;" alt="No image">';
                                                    }
                                                    ?>
                                                </a>
                                                <div>
                                                    <a
                                                        href="<?php echo get_permalink($prev_post); ?>"><?php echo get_the_title($prev_post); ?></a>
                                                    <div class="prev-post">Previous Post</div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-md-6">
                                        <?php $next_post = get_next_post(); ?>
                                        <?php if (!empty($next_post)): ?>
                                            <div class="after-post radius-right d-flex">
                                                <div>
                                                    <a
                                                        href="<?php echo get_permalink($next_post); ?>"><?php echo get_the_title($next_post); ?></a>
                                                    <div class="prev-post">Next Post</div>
                                                </div>
                                                <a href="<?php echo get_permalink($next_post); ?>" class="ms-2"
                                                    style="flex-shrink: 0;">
                                                    <?php
                                                    if (has_post_thumbnail($next_post)) {
                                                        echo get_the_post_thumbnail($next_post, 'thumbnail', ['style' => 'width: 80px; height: auto;']);
                                                    } else {
                                                        echo '<img src="' . esc_url(get_template_directory_uri() . '/assets/img/default-thumb.jpg') . '" style="width: 80px; height: auto;" alt="No image">';
                                                    }
                                                    ?>
                                                </a>
                                            </div>
                                        <?php endif; ?>
                                    </div>

                                </div>
                            </div>


                        </div>

                        <?php
                    endwhile;
                else:
                    echo 'No post found.';
                endif;
                ?>
            </div>

            <div class="col-lg-4 col-md-4 order-md-2 order-1">
                <div class="sidebar-box">

                    <?php
                    $categories = get_categories();
                    if ($categories):
                        ?>
                        <h3 class="cat-color">Categories</h3>
                        <div class="text-start">
                            <ul class="category-list">
                               <li><a href="<?php  echo esc_url(add_query_arg('category', '', home_url('/blog'))); ?>"
                                            class="cats <?php  echo empty($atts['category']) ? 'active' : ''; ?>"> All  </a></li> 
                                <?php foreach ($categories as $category):
                                    $active_class = ($atts['category'] === $category->slug) ? 'active' : '';
                                    ?>
                                    <li>
                                        <a href="<?php echo esc_url(add_query_arg('category', $category->slug, home_url('/blog'))); ?>"
                                            class="cats <?php echo esc_attr($active_class); ?>">
                                            <?php echo esc_html($category->name); ?>

                                            <span> <?php echo esc_html(' ' . $category->count . ''); ?> </span>

                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                        <?php
                    endif; ?>


                    <hr class="sidebar-divider" />




                    <?php
                    $related_posts = get_related_articles(get_the_ID(), 3);

                    if (!empty($related_posts)): ?>
                        <div class="sidebar-articles">
                            <h3 class="cat-color">Recent Posts</h3>
                            <?php foreach ($related_posts as $post):
                                setup_postdata($post); ?>
                                <div class="recent-post d-flex mb-3">
                                    <a href="<?php the_permalink(); ?>" class="me-2" style="flex-shrink: 0;">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('thumbnail', array('style' => 'width: 80px; height: auto;'));
                                        } else {
                                            echo '<img src="' . esc_url(get_template_directory_uri() . '/assets/img/default-thumb.jpg') . '" alt="No image" style="width: 80px; height: auto;">';
                                        } ?>
                                    </a>
                                    <div>
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        <div class="recent-date"><?php echo get_the_date(); ?></div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>

                    <?php
                    wp_reset_postdata();
                    endif;
                    ?>
            </div>
        </div>
    </div>
</div>




<?php get_footer(); ?>