<?php
defined('ABSPATH') || exit;

get_header('shop');
?>



<div class="woocommerce-shop-banner pt-md-5 pb-md-5 pt-4 pb-4">
    <div class="container">
        <div class="row g-md-3 divider-shop">
              <div class="col-md-12">

              <ul>
                 <li> <a href="<?php echo site_url(''); ?>"> Home </a> </li>

                 <li> / </li>
                <li>
                       <?php if (is_product_category()) {
                        $category = get_queried_object();
                        if ($category) { ?>
                            <?php echo '<p class="mb-0">' . esc_html($category->name) . '</p>'; ?>
                        <?php }
                    } else{
                        ?>    <p class="mb-0"> Shop </p> <?php
                        } ?>
                </li>
              </ul>

              </div>
            <div class="col-md-6">
                <div class="banner-title text-start">
                    <?php if (is_product_category()) {
                        $category = get_queried_object();
                        if ($category) { ?>
                            <?php echo '<h1>' . esc_html($category->name) . '</h1>'; ?>
                        <?php } 
                    } else{
                        ?>    <h1> Shop </h1> <?php
                        }
                     ?>
                </div>
            </div>
              <div class="col-md-6">
                           <?php echo '<p>' . esc_html($category->description) . '</p>'; ?> 
              </div>
        </div>
    </div>
</div>

<div class="woo-shop">
    <div class="container">
        <div class="row g-md-5 g-3">
            <div class="col-md-3 c-color">
                <div class="fiter_shop mb-4">
                    <div class="pb-4">
                        <h2 class="title">Categories</h2>
                        <?php echo do_shortcode('[product_categories_accordion]'); ?>
                    </div>

                    <!-- Removed the Brands section -->
                    <!--
                    <div class="pb-4">
                        <h2>Brands</h2>
                        <?php echo do_shortcode('[brand_checkbox_filter]'); ?>
                    </div>
                    -->
                </div>
            </div>

            <div class="col-md-9">
                <div class="custom-product-grid" id="products">
                    <?php if (woocommerce_product_loop()): ?>
                        <?php
                        do_action('woocommerce_before_shop_loop');
                        woocommerce_product_loop_start();
                        if (wc_get_loop_prop('total')) {
                            while (have_posts()) {
                                the_post();
                                do_action('woocommerce_shop_loop');
                                wc_get_template_part('content', 'product');
                            }
                        }
                        woocommerce_product_loop_end();
                        do_action('woocommerce_after_shop_loop');
                        ?>
                    <?php else: ?>
                        <?php do_action('woocommerce_no_products_found'); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
do_action('woocommerce_after_main_content');
get_footer('shop');
?>
