<?php
/**
 * Template Name: Custom Blog Page
 */

get_header();
?>

<div class="container my-5">
    <h1 class="text-center mb-5"><?php the_title(); ?></h1>

    <div class="row g-4">
        <?php
        $paged = get_query_var('paged') ? get_query_var('paged') : 1;
        $selected_category = isset($_GET['category']) ? sanitize_text_field($_GET['category']) : '';

        $args = array(
            'post_type' => 'post',
            'posts_per_page' => 1,
            'paged' => $paged,
            'orderby' => 'date',
            'order' => 'DESC',
        );

        if (!empty($selected_category)) {
            $args['category_name'] = $selected_category;
        }

        $blog_query = new WP_Query($args);
        ?>

        <div class="col-md-4 order-md-2 order-1">
            <div class="sidebar-box">

                <?php
                $categories = get_categories();
                if ($categories):
                ?>
                    <h3 class="cat-color">Categories</h3>
                    <div class="text-start">
                        <ul class="category-list">
                            <li>
                                <a href="<?php echo esc_url(get_permalink()); ?>"
                                   class="cats <?php echo empty($selected_category) ? 'active' : ''; ?>">
                                    All
                                </a>
                            </li>
                            <?php foreach ($categories as $category):
                                $active_class = ($selected_category === $category->slug) ? 'active' : '';
                                ?>
                                <li>
                                    <a href="<?php echo esc_url(add_query_arg('category', $category->slug, get_permalink())); ?>"
                                       class="cats <?php echo esc_attr($active_class); ?>">
                                        <?php echo esc_html($category->name); ?>
                                        <span><?php echo esc_html($category->count); ?></span>
                                    </a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <hr class="sidebar-divider" />

                <h3 class="cat-color">Recent Posts</h3>
                <?php
                $recent_args = array(
                    'post_type' => 'post',
                    'posts_per_page' => 3,
                    'orderby' => 'date',
                    'order' => 'DESC',
                );
                $recent_query = new WP_Query($recent_args);

                if ($recent_query->have_posts()):
                    while ($recent_query->have_posts()):
                        $recent_query->the_post(); ?>
                        <div class="recent-post d-flex mb-3">
                            <a href="<?php the_permalink(); ?>" class="me-2" style="flex-shrink: 0;">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('thumbnail', array('style' => 'width: 80px; height: auto;'));
                                } else {
                                    echo '<img src="' . esc_url(get_template_directory_uri() . '/assets/img/default-thumb.jpg') . '" alt="No image" style="width: 80px; height: auto;">';
                                } ?>
                            </a>
                            <div>
                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                <div class="recent-date"><?php echo get_the_date(); ?></div>
                            </div>
                        </div>
                    <?php endwhile;
                endif;
                wp_reset_postdata();
                ?>

            </div>
        </div>

        <div class="col-md-8 order-md-1 order-2">
            <?php if ($blog_query->have_posts()): ?>
                <div class="blog-page blog-main">
                    <div class="row g-md-5 g-3">
                        <?php while ($blog_query->have_posts()):
                            $blog_query->the_post(); ?>

                            <div class="blog-post-card mb-4">
                                <div class="blog-image-wrapper">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        } ?>
                                    </a>

                                    <?php
                                    $terms = get_the_terms(get_the_ID(), 'category');
                                    if ($terms && !is_wp_error($terms)) {
                                        foreach ($terms as $term) { ?>
                                            <span class="blog-category-badge"><?php echo esc_html(strtolower($term->name)); ?></span>
                                        <?php }
                                    } ?>
                                </div>

                                <div class="blog-content mt-3">
                                    <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                                    <p><?php echo get_the_excerpt(); ?></p>
                                    <a href="<?php the_permalink(); ?>" class="read-more-btn">READ MORE</a>
                                </div>
                            </div>

                        <?php endwhile; ?>
                    </div>

                    <?php if ($blog_query->max_num_pages > 1): ?>
                        <div class="pagination-center text-center mt-md-5 mt-3 mb-3">
                            <div class="pagination-style-one">
                                <?php
                                echo paginate_links(array(
                                    'total' => $blog_query->max_num_pages,
                                    'current' => max(1, get_query_var('paged')),
                                    'format' => '?paged=%#%',
                                    'show_all' => false,
                                    'type' => 'plain',
                                    'prev_text' => '<i class="eicon-chevron-left"></i>',
                                    'next_text' => '<i class="eicon-chevron-right"></i>',
                                    'end_size' => 2,
                                    'mid_size' => 2
                                ));
                                ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <p>No blog posts found.</p>
            <?php endif;

            wp_reset_postdata();
            ?>
        </div>
    </div>
</div>

<?php get_footer(); ?>
