jQuery(function ($) {
    var canBeLoaded = true,
        button = $('#pload-more-btn'),
        page = load_more_params.current_page,
        maxPage = load_more_params.max_page;

    button.on('click', function () {
        if (canBeLoaded) {
            canBeLoaded = false;
            page++;

            $.ajax({
                url: load_more_params.ajaxurl,
                type: 'POST',
                data: {
                    action: 'load_more',
                    page: page
                },
                beforeSend: function () {
                    button.text('Loading...');
                },
                success: function (data) {
                    if (data.trim() !== '') {
                        $('#products ul').append(data);
                        canBeLoaded = true;
                        button.text('Load More');
                    } else {
                        // No more products
                        button.text('No More Products').attr('disabled', 'disabled').fadeOut();
                    }
                },
                error: function () {
                    button.text('Error Loading');
                }
            });
        }
    });
});
