<?php get_header(); ?>

<div class="article-detail">

    <div class="container">
        <div class="row g-3 justify-content-center">
            <div class="col-lg-9">
                <?php
                if (have_posts()):
                    while (have_posts()):
                        the_post();
                        ?>
                        <div class="content-area">
                            <div class="blog-post-card">
                                <div class="blog-image-wrapper">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                    } ?>
                                </div>
                                <div class="blog-content">
                                    <h2><?php echo get_the_title(); ?></h2>
                                    <div class="pt-2">
                                        <?php the_content(); ?>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <?php
                    endwhile;
                else:
                    echo 'No post found.';
                endif;
                ?>

                <div class="share-article text-center mb-md-5 mb-4 d-md-flex align-items-center justify-content-center">
                    <h4 class="mb-0 mt-0 me-md-5">Share this article on</h4>
                    <div class="d-flex justify-content-center gap-4">

                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode(get_permalink()); ?>"
                            target="_blank" rel="noopener noreferrer"
                            class="d-flex align-items-center gap-2">
                            <i class="eicon-facebook"></i> Facebook
                        </a>

                        <a href="https://twitter.com/intent/tweet?url=<?php echo urlencode(get_permalink()); ?>&text=<?php echo urlencode(get_the_title()); ?>"
                            target="_blank" rel="noopener noreferrer"
                            class=" d-flex align-items-center gap-2">
                            <i class="eicon-twitter"></i> Twitter
                        </a>

                    </div>
                </div>


            </div>
        </div>
    </div>

    <div class="more-article">
        <div class="container">

            <?php
            $related_posts = get_related_articles(get_the_ID(), 3);

            if (!empty($related_posts)): ?>
                <div class="row g-md-4 g-3">
                    <div class="col-lg-12">
                        <h3 class="more-title">Other Helpful Articles</h3>
                    </div>
                    <?php foreach ($related_posts as $post):
                        setup_postdata($post); ?>
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <div class="article-box">
                                <a href="<?php the_permalink(); ?>" class="d-block">
                                    <div class="img-box">
                                        <?php if (has_post_thumbnail()) {
                                            the_post_thumbnail('full', array('class' => 'd-block w-100'));
                                        } ?>
                                    </div>
                                    <div class="content-box">
                                        <h2 class="author mb-3">
                                            <?php the_title(); ?>
                                        </h2>

                                        <div class="description description-limit">
                                            <?php echo '' . mb_substr(get_the_excerpt(), 0, 180) . '...'; ?>
                                        </div>

                                        <div class="recent-date"><?php echo get_the_date(); ?></div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <?php
            wp_reset_postdata();
            endif;
            ?>
    </div>
</div>




<?php get_footer(); ?>